#include  <Wire.h>//library pendukung lcd i2c
#include  <LiquidCrystal_I2C.h>//library lcd i2c
#include <OneWire.h>//library pendukung sensor suhu ds18b20
#include<DallasTemperature.h>//library sensor suhu ds18b20
LiquidCrystal_I2C lcd(0x27, 16, 2);//inisialisasi tipe & alamat lcd i2c
OneWire oneWire(3);//inisialisasi pin sensor suhu ds18b20
DallasTemperature DS18B20(&oneWire);//penamanaan sensor suhu

int x;//variabel untuk sensor preassure
float v;//variabel untuk sensor preassure
float psi;//variabel untuk sensor preassure
float bar;//variabel untuk sensor preassure
float temp;//variabel untuk sensor suhu

unsigned long waktusebelum1 = 0;//waktu untuk fungsi delay sensor pressure
unsigned long waktusebelum2 = 0;//waktu untuk fungsi delay sensor suhu

void setup() {
  Serial.begin(9600);
  lcd.init();//fungsi untuk memulai lcd
  lcd.backlight();//fungsi untuk menyalakan lampu lcd
  DS18B20.begin();//fungsi untuk memulai sensor suhu
  lcd.setCursor(3, 0);
  lcd.print("Monitoring");
  lcd.setCursor(0, 1);
  lcd.print("tekanan dan suhu");
  delay(3000);
  lcd.clear();
}

void loop() {
  /*float p_pascal = (3.0 * (v - 0.47)) * 1000000.0;
  float p_bar = p_pascal / 10e5;
  Serial.print("sensor value:");
  Serial.print(x);
  Serial.print("  volt:");
  Serial.print(v);
  Serial.print("  psi:");
  Serial.print(psi);
  Serial.print("  pascal:");
  Serial.print(p_pascal);
  Serial.print("  pressure:");
  Serial.println(p_bar);*/

  unsigned long waktusekarang1 = millis();
  if (waktusekarang1 - waktusebelum1 >= 1000) {
    x = analogRead(A0);//pembacaan nilai analog dari sensor preassure
    v = x * (5.0 / 1024.0);//konversi nilai adc
    psi = 250 * (v / 5.0);//rumus untuk dapat nilai psi
    psi = psi - 24;//kalibrasi sensor preassure
    if (psi < 1) {
      psi = 0;
    }
    bar = psi * 0.0689476;
    //fungsi untuk menampilkan hasil sensor ke lcd
    lcd.setCursor(0, 0);
    lcd.print("P: ");
    lcd.print(bar);
    lcd.print("BAR ");
    waktusebelum1 = millis();
  }
  unsigned long waktusekarang2 = millis();
  if (waktusekarang2 - waktusebelum2 >= 500) {
    DS18B20.requestTemperatures();//fungsi untuk pembacaan sensor suhu
    temp = DS18B20.getTempCByIndex(0);//inisialisasi hasil pembacaan sensor
    //fungsi untuk menampilkan hasil sensor ke lcd
    lcd.setCursor(0, 1);
    lcd.print("Suhu= ");
    lcd.print(temp);
    lcd.print((char)223);
    lcd.print("C  ");
    waktusebelum2 = millis();
  }
}
